class Sprite_Stand extends PIXI.Container{
    constructor() {
        super()
        this.loadBitmap()
    }

    hideStand(){
        this.alpha=0
    }

    showStand(){
        this.alpha=1
    }

    loadBitmap() {
        this.body = new Sprite()
        this.cloth = new Sprite()
        this.emote = new Sprite()
        this.effect1 = new Sprite()
        this.effect2 = new Sprite()
        this.refreshAll()
        this.position = new Point(520, 0)
        this.addChild(this.body)
        this.addChild(this.cloth)
        this.addChild(this.emote) 
        this.addChild(this.effect2)  
        this.addChild(this.effect1)
    }

    refreshEffect() {
        for (let i = 124; i <= 128; i++) {
            if ($gameSwitches.value(24) && $gameSwitches.value(i)) {
                this.effect1.bitmap = ImageManager.loadPicture()
                this.cloth.bitmap = ImageManager.loadPicture("kerys_C5")
                this.body.bitmap = ImageManager.loadPicture("kerys7")
                this.emote.bitmap = ImageManager.loadPicture("kerys_E0")
                return;
            }
            if ($gameSwitches.value(i)) {
                this.effect1.bitmap = ImageManager.loadPicture(`patch${i - 124}`)
                this.emote.bitmap = ImageManager.loadPicture("kerys_E8")
                return;
            }
        }
        this.effect1.bitmap = null
            if (!this.emote.bitmap) {
                this.emote.bitmap = ImageManager.loadPicture("kerys_E1")
        }
    }

    refreshAll() {
        this.emote.bitmap = null;
        let code1='0',code2='0';
        if($gameSwitches.value(130))
            code1='1'
        if($gameSwitches.value(131))
            code2='1'
        if($gameSwitches.value(132))
            code2='2'
        if($gameSwitches.value(133))
            code2='3'
        if($gameSwitches.value(18))
            code2='4'
        if($gameSwitches.value(24))
            code2='5'
        let code=code1+code2
        if ($gameSwitches.value(101)) {
            switch(code){
                case '05':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C5")
                    this.body.bitmap = ImageManager.loadPicture("kerys6")
                    this.emote.bitmap = ImageManager.loadPicture("kerys_E0")                    
                    break;
                }
                case '04':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C5")
                    this.body.bitmap = ImageManager.loadPicture("kerys5")
                    this.emote.bitmap = ImageManager.loadPicture("kerys_E0")                    
                    break;
                }
                case '03':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C5")
                    this.body.bitmap = ImageManager.loadPicture("kerys4")
                    this.effect2.bitmap = ImageManager.loadPicture("helmet1")
                    this.emote.bitmap = ImageManager.loadPicture("kerys_E3")
                    break;
                }
                case '01':{}
                case '11':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C5")
                    this.body.bitmap = ImageManager.loadPicture("kerys3")
                    break;
                }
                case '02':{}
                case '12':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C5")
                    this.body.bitmap = ImageManager.loadPicture("kerys2")
                    this.effect2.bitmap = ImageManager.loadPicture("helmet0")
                    break;
                }
                case '10':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C4")
                    this.body.bitmap = ImageManager.loadPicture("kerys")
                    break;
                }
                case '00':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C2")
                    this.body.bitmap = ImageManager.loadPicture("kerys")
                    break;
                }
            
            }
        }
        else {
            switch(code){
                case '11':{}
                case '12':{}
                case '10':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C3")
                    this.body.bitmap = ImageManager.loadPicture("kerys")
                    break;
                }
                case '01':{}
                case '02':{}
                case '00':{
                    this.cloth.bitmap = ImageManager.loadPicture("kerys_C1")
                    this.body.bitmap = ImageManager.loadPicture("kerys")
                    break;
                }
        }
    }
    if (!this.emote.bitmap) {
    this.emote.bitmap = ImageManager.loadPicture("kerys_E1")
    }
        this.refreshEffect()
    }
}


class Sprite_StandBattle extends Sprite_Stand{
    constructor() {
        super()
        $gameExtraData.registerStandBattle(this)
    }
}

Sprite_StandBattle.prototype.preloadAnimationBitmap=function(){
    for(let i=1;i<7;i++){
        ImageManager.loadPicture(`kerysA1_${i}`)
    }
}

Sprite_StandBattle.prototype.changeBitmap=function(part,fileName){
    this[part].bitmap=ImageManager.loadPicture(fileName)
    // this[part].bitmap=ImageManager.loadPicture("kerysA1_1")
}

Scene_Battle.prototype.createDisplayObjects = function () {
    this.createSpriteset();
    this.createStand()
    this.createWindowLayer();
    this.createAllWindows();
    BattleManager.setLogWindow(this._logWindow);
    BattleManager.setStatusWindow(this._statusWindow);
    BattleManager.setSpriteset(this._spriteset);
    this._logWindow.setSpriteset(this._spriteset);
};

Scene_Battle.prototype.createStand = function () {
    this._battleStand = new Sprite_StandBattle()
    this.addChild(this._battleStand)
}

Scene_Battle.prototype.terminate = function() {
    Scene_Base.prototype.terminate.call(this);
    $gameParty.onBattleEnd();
    $gameTroop.onBattleEnd();
    AudioManager.stopMe();
    ImageManager.clearRequest();
    $gameExtraData.removeStandBattle()
};

Game_Switches.prototype.onChange = function() {
    $gameMap.requestRefresh();
    if($gameExtraData.standBattle){
        $gameExtraData.standBattle.refreshAll()
    }
};

(function() {

    const _Sprite_Actor_setActorHome = Sprite_Actor.prototype.setActorHome;
    Sprite_Actor.prototype.setActorHome = function(index) {
        _Sprite_Actor_setActorHome.call(this, index);
        this.setHome(900, 360);  // ← 強制覆蓋
    };

})();



(function() {

    const StandSkillPose = {
        30: { 
            emote: "kerys_E0",
            cloth: "kerys_C5",
            body:"kerys6"
        }
    };

    BattleManager._standSkillPoseOn = false;

    const _BattleManager_startAction = BattleManager.startAction;
    BattleManager.startAction = function() {
        const subject = this._subject;
        const action  = subject ? subject.currentAction() : null;

        if (subject && subject.isActor() && action && action.item()) {
            const item = action.item();
            if (DataManager.isSkill(item)) {
                const skillId = item.id;
                const cfg = StandSkillPose[skillId];

                if (cfg && $gameExtraData && $gameExtraData.standBattle) {
                    const stand = $gameExtraData.standBattle;

                    if (cfg.body)    stand.changeBitmap("body",    cfg.body);
                    if (cfg.cloth)   stand.changeBitmap("cloth",   cfg.cloth);
                    if (cfg.emote)   stand.changeBitmap("emote",   cfg.emote);
                    if (cfg.effect1) stand.changeBitmap("effect1", cfg.effect1);
                    if (cfg.effect2) stand.changeBitmap("effect2", cfg.effect2);

                    BattleManager._standSkillPoseOn = true;
                }
            }
        }

        _BattleManager_startAction.call(this);
    };

    const _BattleManager_endAction = BattleManager.endAction;
    BattleManager.endAction = function() {
        _BattleManager_endAction.call(this);

        if (BattleManager._standSkillPoseOn && $gameExtraData && $gameExtraData.standBattle) {
            $gameExtraData.standBattle.refreshAll();
            BattleManager._standSkillPoseOn = false;
        }
    };

})();



(function() {

    var SKILL31 = 31;  
    var SKILL32 = 32;   

    var _displayAction = Window_BattleLog.prototype.displayAction;
    Window_BattleLog.prototype.displayAction = function(subject, item) {
        if (item && DataManager.isSkill(item) &&
            (item.id === SKILL31 || item.id === SKILL32)) {

            var origMsg2 = item.message2; 
            item.message2 = "";   

            _displayAction.call(this, subject, item); 

            item.message2 = origMsg2;   
        } else {
            _displayAction.call(this, subject, item);
        }
    };

    window.Skill32_ShowMessage2 = function() {
        var log  = BattleManager._logWindow;
        var item = $dataSkills[SKILL32];
        if (log && item && item.message2) {
            log.addText(item.message2.format(item.name));
        }
    };

    window.Skill32_ApplyDamage = function() {
        var actor = $gameActors.actor(1);   
        if (!actor) return;

        var log  = BattleManager._logWindow;

        var atk          = actor.param(2);
        var base         = atk;
        var varianceRate = 0.20;
        var variance     = Math.floor(base * varianceRate);
        var dmg = Math.floor(
            base * 38 + (Math.randomInt(variance * 2 + 1) - variance)
        );

        var pattern = $dataSystem.terms.messages.enemyDamage
                   || "%1受到了%2點傷害！";

        $gameTroop.members().forEach(function(enemy) {
            if (!enemy || !enemy.isAlive()) return;

            enemy.gainHp(-dmg);

            var res = enemy.result();
            res.clear();
            res.hpAffected = true;
            res.hpDamage   = dmg;

            enemy.startDamagePopup();
            enemy.refresh();

            if (log) {
                var text = pattern.format(enemy.name(), dmg);
                log.addText(text);
            }

            if (enemy.hp <= 0) {
                enemy.performCollapse();
                enemy.refresh();
            }
        });
    };

    window.Skill31_ShowMessage2 = function() {
        var log  = BattleManager._logWindow;
        var item = $dataSkills[SKILL31];
        if (log && item && item.message2) {
            log.addText(item.message2.format(item.name));
        }
    };

window.Skill31_ApplySelfDamage = function() {
    var user = BattleManager._subject || $gameActors.actor(1);
    if (!user) return;

    var log = BattleManager._logWindow;
    var dmg = 999;

    user.gainHp(-dmg);

    var res = user.result();
    res.clear();
    res.hpAffected = true;
    res.hpDamage   = dmg;

    user.startDamagePopup();
    user.refresh();

    if (log) {
        var pattern = $dataSystem.terms.messages.actorDamage
                   || "%1受到了%2點傷害！";
        var text = pattern.format(user.name(), dmg);
        log.addText(text);
    }

    if (user.hp <= 0) {
        user.performCollapse();
        user.refresh();
    }
};

})();

    BattleManager.processDefeatSkill31 = function() {
        var _displayDefeatMessage = this.displayDefeatMessage;
        this.displayDefeatMessage = function() {};
        this.processDefeat();
        this.displayDefeatMessage = _displayDefeatMessage;
    };



Sprite_Enemy.prototype.damageOffsetX = function() {
    return 0;   // 往右是正，往左就填負數
};
Sprite_Enemy.prototype.damageOffsetY = function() {
    return -100; // 往上是負，往下是正
};